#include <afxwin.h>
#include <struct.h>
#include <3dengine.h>
#include "pageopensave.h"
#include "../resource.h"

BEGIN_MESSAGE_MAP(COpenSavePage, CPropertyPage)
  ON_BN_CLICKED(IDC_OPENSAVESPLINESCHECK,      OnSplines)
  ON_BN_CLICKED(IDC_OPENSAVECUSTOMSPLINESCHECK,  OnCustomSplines)
  ON_BN_CLICKED(IDC_OPENSAVEUNDATACHECK,      OnUnData)
  ON_BN_CLICKED(IDC_OPENSAVEVIEWSCHECK,      OnViews)

  ON_BN_CLICKED(IDC_OPENSAVEIMAGESCHECK,      OnImages)
  ON_BN_CLICKED(IDC_OPENSAVECOMPRESSIONCHECK,    OnCompression)

  ON_BN_CLICKED(IDC_OPENSAVEAUTOSAVECHECK,    OnAutoSave)
  ON_EN_CHANGE(IDC_OPENSAVEAUTOSAVEEDIT,      OnIntervalChange)
END_MESSAGE_MAP()


BOOL COpenSavePage::OnInitDialog()
{
  CDialog::OnInitDialog();
  OpenSaveFlags       =    CurrentState.nOpenSaveFlags;
  pSplinesCheck       = (CButton*)GetDlgItem(IDC_OPENSAVESPLINESCHECK);
  pCustomSplinesCheck = (CButton*)GetDlgItem(IDC_OPENSAVECUSTOMSPLINESCHECK);
  pUnDataCheck        = (CButton*)GetDlgItem(IDC_OPENSAVEUNDATACHECK);
  pViewsCheck         = (CButton*)GetDlgItem(IDC_OPENSAVEVIEWSCHECK);
  pImagesCheck        = (CButton*)GetDlgItem(IDC_OPENSAVEIMAGESCHECK);
  pCompressionCheck   = (CButton*)GetDlgItem(IDC_OPENSAVECOMPRESSIONCHECK);
  pAutoSaveCheck      = (CButton*)GetDlgItem(IDC_OPENSAVEAUTOSAVECHECK);
  pEdit               = (CEdit*)GetDlgItem(IDC_OPENSAVEAUTOSAVEEDIT);


  pSplinesCheck->SetCheck(OpenSaveFlags & Z3D_OPENSAVE_SPLINES ? 1:0);
  pCustomSplinesCheck->SetCheck(OpenSaveFlags & Z3D_OPENSAVE_CUSTOMSPLINES ? 1:0);
  pUnDataCheck->SetCheck(OpenSaveFlags & Z3D_OPENSAVE_UNSUPPDATA ? 1:0);
  pViewsCheck->SetCheck(OpenSaveFlags & Z3D_OPENSAVE_VIEWS ? 1:0);
  pImagesCheck->SetCheck(OpenSaveFlags & Z3D_OPENSAVE_STOREIMAGES ? 1:0);
  pCompressionCheck->SetCheck(OpenSaveFlags & Z3D_OPENSAVE_COMPRESSION ? 1:0);
  pAutoSaveCheck->SetCheck(OpenSaveFlags & Z3D_OPENSAVE_AUTOSAVE ? 1:0);
  
  OnAutoSave();
  pEdit->SetLimitText(3);
  pEdit->EnableWindow(OpenSaveFlags & Z3D_OPENSAVE_AUTOSAVE ? TRUE: FALSE);
  pEdit->SetWindowText(Int2String((OpenSaveFlags & 0xFF000000)>>24).GetBuffer(3));

  CButton* pCheck;
  pCheck = (CButton*)GetDlgItem(IDC_CHECK_PROGRAMMING);
  pCheck->SetCheck(CurrentState.IsMode(Z3D_MODE_PROGRAMMING) ? 1:0);
  pCheck = (CButton*)GetDlgItem(IDC_CHECK_DEBUALL);
  pCheck->SetCheck(CurrentState.IsMode(Z3D_MODE_DEBUGALL) ? 1:0);

  CurrentState.CurrentParams.sysp(
      Z3D_REQUEST_LOCALIZE_USER_DIALOG, NULL, "ZModeler\\Settings\\OpenSave Page", this, NULL);

  return TRUE;
}



afx_msg void COpenSavePage::OnSplines()
{
  if (pSplinesCheck->GetCheck() == 1)
    OpenSaveFlags |= Z3D_OPENSAVE_SPLINES;
  else
    OpenSaveFlags &= ~Z3D_OPENSAVE_SPLINES;
  SetModified(TRUE);
}

afx_msg void COpenSavePage::OnCustomSplines()
{
  if (pCustomSplinesCheck->GetCheck() == 1)
    OpenSaveFlags |= Z3D_OPENSAVE_CUSTOMSPLINES;
  else
    OpenSaveFlags &= ~Z3D_OPENSAVE_CUSTOMSPLINES;
  SetModified(TRUE);
}

afx_msg void COpenSavePage::OnUnData()
{
  if (pUnDataCheck->GetCheck() == 1)
    OpenSaveFlags |= Z3D_OPENSAVE_UNSUPPDATA;
  else
    OpenSaveFlags &= ~Z3D_OPENSAVE_UNSUPPDATA;
  SetModified(TRUE);
}

afx_msg void COpenSavePage::OnViews()
{
  if (pViewsCheck->GetCheck() == 1)
    OpenSaveFlags |= Z3D_OPENSAVE_VIEWS;
  else
    OpenSaveFlags &= ~Z3D_OPENSAVE_VIEWS;
  SetModified(TRUE);
}

afx_msg void COpenSavePage::OnImages()
{
  if (pImagesCheck->GetCheck() == 1)
    OpenSaveFlags |= Z3D_OPENSAVE_STOREIMAGES;
  else
    OpenSaveFlags &= ~Z3D_OPENSAVE_STOREIMAGES;
  SetModified(TRUE);
}

afx_msg void COpenSavePage::OnCompression()
{
  if (pCompressionCheck->GetCheck() == 1)
    OpenSaveFlags |= Z3D_OPENSAVE_COMPRESSION;
  else
    OpenSaveFlags &= ~Z3D_OPENSAVE_COMPRESSION;
  SetModified(TRUE);
}


afx_msg void COpenSavePage::OnAutoSave()
{
  if (pAutoSaveCheck->GetCheck() == 1)
  {
    OpenSaveFlags |= Z3D_OPENSAVE_AUTOSAVE;
    pEdit->EnableWindow();
  }
  else
  {
    OpenSaveFlags &= ~Z3D_OPENSAVE_AUTOSAVE;
    pEdit->EnableWindow(FALSE);
  }
  SetModified(TRUE);
}

afx_msg void COpenSavePage::OnIntervalChange()
{
  char str[4];
  pEdit->GetWindowText(str, 4);
  unsigned long value = String2Int(CString(str));
  if (value > 240) value = 240;
  if (value < 3) value = 3;

  OpenSaveFlags = (OpenSaveFlags & 0xFFFFFF) | (value << 24);
  SetModified(TRUE);
}

BOOL COpenSavePage::OnApply()
{
  CurrentState.nOpenSaveFlags = OpenSaveFlags;
  return TRUE;
}


BOOL COpenSavePage::OnKillActive()
{
  CButton* pCheck;
  pCheck = (CButton*)GetDlgItem(IDC_CHECK_PROGRAMMING);
  if (pCheck->GetCheck() == 1)
    CurrentState.SetMode(Z3D_MODE_PROGRAMMING);
  else
    CurrentState.SetMode(CurrentState.GetMode() & ~Z3D_MODE_PROGRAMMING);
  pCheck = (CButton*)GetDlgItem(IDC_CHECK_DEBUALL);
  if (pCheck->GetCheck() == 1)
    CurrentState.SetMode(Z3D_MODE_DEBUGALL);
  else
    CurrentState.SetMode(CurrentState.GetMode() & ~Z3D_MODE_DEBUGALL);
  return TRUE;
}